// CSC 171
// Project1 Tester

package grader;

import java.util.Vector;

public class ConverterTest
{
	
    public static void main (String args[])
    {
	Vector classList = ClassFinder.findClassExtensions(".","grader.Converter",false);

	if (classList.size() == 0)
	    {
		System.out.println("No Converter Implementation Found!\n");
		System.exit(1);
	    }

	if (classList.size()>1){

	    //multiple implementations found
	    System.out.println(classList.size()+" implementations found!\n"+"Test one by one...\n");
	}

	for (int i=0; i<classList.size();i++){

	    System.out.println("\nTesting "+(String) classList.elementAt(i) +"...\n");

	    try{
		Class testClass = Class.forName( (String) classList.elementAt(i));
		Converter converter = (Converter) testClass.newInstance();
		
		System.out.println("Your name:  " + converter.getName() + "\n");
		System.out.println("Your email: " + converter.getEmail() + "\n");
		System.out.println("Your answers:\n"
				   + "\t 1 mile = " + converter.mile2kilometer(1.0) + " kilometers\n"
				   + "\t 1 quart = "+ converter.quart2liter(1.0) +" liters\n"
				   + "\t 1 kilogram = " + converter.kilogram2pound(1.0) + " pounds\n"
				   );

		System.out.println("Your answer for the extra credit:\n"
				   + "\t 1 mile = " + converter.convert("mile", "kilometer", 1.0)
				   + " kilometers\n");
		
	    }
	    catch (ClassNotFoundException cnfe){
		
		// This shouldn't happen, since ClassFinder checks this, but just in case...
		System.err.println(cnfe);
		System.exit(0);
	    }

	    catch (Exception exception){
		exception.printStackTrace();
	    }
	}

    }


}

// The following three lines of comments are emacs-editor 
// specific -- they set the command line which will appear 
// when you invoke the compile command (M-x compile) while
// editing this file in an emacs buffer.

// Emacs variables
// Local Variables:
// compile-command: "javac -classpath ..:%CLASSPATH% ConvertTest.java"
