package grader;

import java.io.*;
import java.util.Vector;

public class ClassFinder
{

	  // classList will hold a list of all the classes
	  
	  static Vector classList;

	  // This is the only public method in this class.  It will find a list of classes
	  // in the sub-directory specified (sD), which instantiate the class specified
	  // (className), recursively examining subdirectories if desired (recursive).

	  public static Vector findClassExtensions(String sD, String className, boolean recursive)
	  {
		 // Create a file object named 'startDir' from the parameter.
		 // The string sD can be either a relative or an absolute path.
		 // Often, you will wish to search the current directory (and possibly its 
		 // subdirectories), so one might pass in the parameter "."

		 File startDir = new File(sD);
		 
		 // If the object is passed a string which turns out either not to be a 
		 // directory or not to exist at all, then we return an empty vector..

		 // (in Java, at least at the point I 
		 // wrote this code, if a File object is instantiated with a name which 
		 // does not represent an actual file or directory, then the call 
		 // File.isDirectory() will return true, because it could possibly be a 
		 // directory if you create it...)

		 if ( ! (startDir.isDirectory() && startDir.exists())) return new Vector();
	
		 // We better check that the class which the caller has sent in is in fact a 
		 // class which the Java classLoader knows about, and then we should create  
		 // a Class object named goalClass out of it (this enables the system to check
		 // the user's classes to determine if they can be used with the goal class).

		 Class goalClass = null;
		 try
		 {
			goalClass = Class.forName(className);
		 }
		 catch (ClassNotFoundException e) { return new Vector(); }
		 
		 //System.out.println("require class correct\n");
		 // Ok, start a new list of classes.
		 classList = new Vector();

		 // fCE is a method which does most of the work -- we pass it the current directory,
		 // as a File object, the class we want to find children of in the inheiritance 
		 // heirarchy as a Class object, a boolean which specifies whether or not we need to 
		 // recursively search sub-directories, and a string which is the absolute path 
		 // name of the starting directory.
		 fCE(startDir, goalClass, recursive, startDir.getAbsolutePath());

		 // When fCE has done its job, classList will contain a list of all the classes which 
		 // are descendents of the goalClass which it could find.
		 return classList;
	  }
	  
	  private static void fCE(File dir, Class goalClass, boolean recursive, String startDir)
	  {
		  // fileList is an array of strings, each of which is a file in the directory listing 
		  // of dir.
		 String[] fileList = dir.list();
		 
		 // for each file
		 for (int i = 0; i < fileList.length; i++)
		 {
			 // If it is a class file, check to see if it is a descendent of the goal class,
			 // and if it is, add it to classList (which is a static member variable, which 
			 // is why it is not passed as an argument.

		     //System.out.println(i+fileList[i]+"\n");
			 if (fileList[i].endsWith(".class"))
				 {
					 checkIfClass(makeClassName(dir,startDir,fileList[i]),goalClass);
				 }

			 // If we are doing a recursive search, then for every file we need to check 
			 // that it is a directory (since some sicko might name a directory computer.class or
			 // something :-)

			if (recursive)
			{
				// create a File object from the name of the current file.
			   File d = new File(dir,fileList[i]);

			   // if it is a directory, recursively search it.
			   if (d.isDirectory())
			   {
				  fCE(d,goalClass,recursive,startDir);
			   }
			}   
		 }
		 
	  }
	  
	// makeClassName takes a directory, an absolute path name and a file name, and 
	// returns the name of the java class associated with the filename found.
	// Because of java's particular notions of directory structure and class naming,
	// this is fairly simple -- any directories lower down in the heirarchy than the 
	// root get their directory names turned into package names..

	  private static String makeClassName(File dir, String startDir, String file)
	  {
		  // get the filename, with .class removed.
		 String filename = file.substring(0,file.length()-".class".length());
		 // get the path of the new file.
		 String myPath = dir.getAbsolutePath();

		 // if it is the same as the path of the startDir, then we just return the 
		 // class name.
		 if (myPath.equals(startDir)) return filename;

		 // Otherwise, turn the slashes into dots, and return the result.
		 // (e.g. grader/util ClassFinder ->   grader.util.ClassFinder

		 if (!myPath.startsWith(startDir)) return "";  // should never happen
		 String path = myPath.substring(startDir.length()+1); //handle extra fileSeparator
		 path.replace(File.separatorChar,'.');
		 return path + "." + filename;
	  }

	// This method checks if the class named by the String filename is a descendent in 
	// the class heirarchy of the goalClass.
		 
	  private static void checkIfClass(String filename, Class goalClass)
	  {
	      //System.out.println("check file:"+filename+"\n");
		  // Create a storage object for the new class.
		 Class c = null;
		 
		 // If it cannot be instantiated, do nothing.
		 try
		 {
			c = Class.forName(filename);
		 }  // no skin off my back if its not a class....
		 catch (ClassNotFoundException e ) { return; }
		 
		 // If we've found a class which is a sub-class of some sort of goalclass 
		 // e.g. the syntax:   GoalClass g = new c(); will work , and c is not an
		 // interface, then add it to the list of candidate classes.

		 //System.out.print(c.getName());
		 if (goalClass.isAssignableFrom(c) && !c.isInterface()) 
		 {
			classList.addElement(c.getName());
		 }
	  }
}

// The following three lines of comments are emacs-editor 
// specific -- they set the command line which will appear 
// when you invoke the compile command (M-x compile) while
// editing this file in an emacs buffer.

// Emacs variables
// Local Variables:
// compile-command: "javac -classpath ..:%CLASSPATH% ClassFinder.java"





